package app.firezone.synk.network.Fragments;

import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.ValueEventListener;
import app.firezone.synk.network.Adapter.ClassicResultAdapter;
import app.firezone.synk.network.databinding.FragmentLudoResultsBinding;
import app.firezone.synk.network.model.ResultModel;

import java.util.ArrayList;


public class LudoResultsFragment extends Fragment {


    FragmentLudoResultsBinding binding;

    ArrayList<ResultModel> mlist = new ArrayList<>();
    ClassicResultAdapter myAdapter;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        binding =  FragmentLudoResultsBinding.inflate(inflater, container, false);
        View view = binding.getRoot();


        binding.ludoRecy.setLayoutManager(new LinearLayoutManager(getContext()));
        mlist.clear();


        FirebaseDatabase.getInstance().getReference().child("New Match").child("Result Match").child("LUDO")
                .addListenerForSingleValueEvent(new ValueEventListener() {
                    @Override
                    public void onDataChange(@NonNull DataSnapshot snapshot) {
                        for (DataSnapshot snapshot1: snapshot.getChildren()){
                            ResultModel match_model = snapshot1.getValue(ResultModel.class);
                            mlist.add(match_model);

                        }

                        myAdapter = new ClassicResultAdapter(mlist, getContext());
                        binding.ludoRecy.setAdapter(myAdapter);
                    }

                    @Override
                    public void onCancelled(@NonNull DatabaseError error) {

                    }
                });



        return view;
    }
}